/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported;

import java.io.DataInputStream;
import java.io.IOException;
import libsidplay.components.cart.Cartridge;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;

public class OceanType1
extends Cartridge {
    protected int currentRomBank;
    protected final byte[][] romLBanks;
    private final Bank io1Bank = new Bank(){

        @Override
        public byte read(int address) {
            return OceanType1.this.pla.getDisconnectedBusBank().read(address);
        }

        @Override
        public void write(int address, byte value) {
            if (address == 56832) {
                OceanType1.this.currentRomBank = value & 0x3F;
                OceanType1.this.pla.setGameExrom(false, (value & 0x80) != 0);
            }
        }
    };
    private final Bank romlBank = new Bank(){

        @Override
        public byte read(int address) {
            return OceanType1.this.romLBanks[OceanType1.this.currentRomBank][address & 0x1FFF];
        }
    };

    public OceanType1(DataInputStream dis, PLA pla) throws IOException {
        super(pla);
        byte[] chipHeader = new byte[16];
        this.romLBanks = new byte[64][];
        for (int i = 0; i < 64 && dis.available() > 0; ++i) {
            this.romLBanks[i] = new byte[8192];
            dis.readFully(chipHeader);
            if (chipHeader[11] >= 64 || (chipHeader[12] & 0xFF) != 128 && (chipHeader[12] & 0xFF) != 160) {
                throw new RuntimeException("Unexpected Chip header!");
            }
            int bank = chipHeader[11] & 0xFF;
            dis.readFully(this.romLBanks[bank]);
        }
    }

    @Override
    public Bank getRoml() {
        return this.romlBank;
    }

    @Override
    public Bank getIO1() {
        return this.io1Bank;
    }

    @Override
    public void reset() {
        super.reset();
        this.io1Bank.write(56832, (byte)0);
    }
}

